let boxes;
let angle = 0;
shapeArr = [];

function setup() {
  createCanvas(1000,700);
  angleMode(DEGREES);
  
  boxes = new Box();

  for ( let i = 0; i < 5 ; i++) {
    shapeArr.push (new Box(random(0, width), random(0, height), random(0,100)));
    }

}

function draw() {
  background(5,5); // translucent background (creates trails)
   
  

  for (let i = 0; i < 5 ; i++) {
    shapeArr[i].move();
    shapeArr[i].display();
  }
  

}

class Box {

  constructor( callX, callY, callR){
    this.x = callX ;
    this.y = callY ;
    this.r = callR;
    this.colour = 255;
    this.xSpeed = random(0,4);
    this.ySpeed = random(0,-4);
    this.angle = 1;
  }

  move(){

    if ( this.x > width || this.x < 0) {
      this.xSpeed = this.xSpeed * -1 ;
    }
  
    if ( this.y > height || this.y < 0) {
      this.ySpeed = this.ySpeed * -1;
    }

    this.x = (this.x + this.xSpeed);
    this.y = (this.y + this.ySpeed);

    if ( this.r > 100 ){
      this.r = this.r * -1;
    }

    this.r = (this.r + 1 );

    if ( this.x < 500) {
      this.colour = this.colour * -1 ;
      
    }


  }

  display(){

  
  push();
  translate(this.x,this.y);
  rectMode(CENTER)
  rotate(angle);
  fill(this.colour);

  stroke(0);
  strokeWeight(1);
  line(this.x,this.y,100,50);
  

  stroke(255);
  strokeWeight(3);
  square(0,0,this.r);

  stroke(0);
  strokeWeight(1);
  ellipse(0,0,this.r / 1.2);

  rotate(angle + 0.01);

  stroke(255);
  strokeWeight(1);
  square(0,0,this.r/2);
  
  stroke(0)
  strokeWeight(1);
  ellipse(0,0,this.r/2.2);

  
  pop();
   
  
  stroke(255);
  strokeWeight(1);
  line(this.x, this.y,500 ,350, 100, 50);
  

  

  angle = angle + 1;


  }

}
